<?php
/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */

/** @var $category \Magento\Catalog\Model\Category */
$objectManager = \Magento\TestFramework\Helper\Bootstrap::getObjectManager();

$categoryFirst = $objectManager->create('Magento\Catalog\Model\Category');
$categoryFirst->setName(
    'Category 1'
)->setPath(
    '1/2'
)->setLevel(
    2
)->setAvailableSortBy(
    'name'
)->setDefaultSortBy(
    'name'
)->setIsActive(
    true
)->setPosition(
    1
)->save();

$categorySecond = $objectManager->create('Magento\Catalog\Model\Category');
$categorySecond->setName(
    'Category 2'
)->setPath(
    '1/2'
)->setLevel(
    2
)->setAvailableSortBy(
    'name'
)->setDefaultSortBy(
    'name'
)->setIsActive(
    true
)->setPosition(
    2
)->save();

$categoryThird = $objectManager->create('Magento\Catalog\Model\Category');
$categoryThird->setName(
    'Category 3'
)->setPath(
    $categoryFirst->getPath()
)->setLevel(
    3
)->setAvailableSortBy(
    'name'
)->setDefaultSortBy(
    'name'
)->setIsActive(
    true
)->setPosition(
    2
)->save();

$categoryFourth = $objectManager->create('Magento\Catalog\Model\Category');
$categoryFourth->setName(
    'Category 4'
)->setPath(
    $categoryThird->getPath()
)->setLevel(
    4
)->setAvailableSortBy(
    'name'
)->setDefaultSortBy(
    'name'
)->setIsActive(
    true
)->setPosition(
    1
)->save();

$categoryFifth = $objectManager->create('Magento\Catalog\Model\Category');
$categoryFifth->setName(
    'Category 5'
)->setPath(
    $categorySecond->getPath()
)->setLevel(
    3
)->setAvailableSortBy(
    'name'
)->setDefaultSortBy(
    'name'
)->setIsActive(
    true
)->setPosition(
    2
)->save();

/** @var $productFirst \Magento\Catalog\Model\Product */
$productFirst = $objectManager->create('Magento\Catalog\Model\Product');
$productFirst->setTypeId(
    'simple'
)->setId(
    1
)->setAttributeSetId(
    4
)->setWebsiteIds(
    [1]
)->setName(
    'Simple Product 01'
)->setSku(
    'simple 01'
)->setPrice(
    10
)->setMetaTitle(
    'meta title'
)->setMetaKeyword(
    'meta keyword'
)->setMetaDescription(
    'meta description'
)->setVisibility(
    \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH
)->setStatus(
    \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
)->setStockData(
    ['use_config_manage_stock' => 0]
)->save();

/** @var $productSecond \Magento\Catalog\Model\Product */
$productSecond = $objectManager->create('Magento\Catalog\Model\Product');
$productSecond->setTypeId(
    'simple'
)->setId(
    2
)->setAttributeSetId(
    4
)->setWebsiteIds(
    [1]
)->setName(
    'Simple Product 02'
)->setSku(
    'simple 02'
)->setPrice(
    10
)->setMetaTitle(
    'meta title'
)->setMetaKeyword(
    'meta keyword'
)->setMetaDescription(
    'meta description'
)->setVisibility(
    \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH
)->setStatus(
    \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
)->setStockData(
    ['use_config_manage_stock' => 0]
)->save();

/** @var $productThird \Magento\Catalog\Model\Product */
$productThird = $objectManager->create('Magento\Catalog\Model\Product');
$productThird->setTypeId(
    'simple'
)->setId(
    3
)->setAttributeSetId(
    4
)->setWebsiteIds(
    [1]
)->setName(
    'Simple Product 03'
)->setSku(
    'simple 03'
)->setPrice(
    10
)->setMetaTitle(
    'meta title'
)->setMetaKeyword(
    'meta keyword'
)->setMetaDescription(
    'meta description'
)->setVisibility(
    \Magento\Catalog\Model\Product\Visibility::VISIBILITY_BOTH
)->setStatus(
    \Magento\Catalog\Model\Product\Attribute\Source\Status::STATUS_ENABLED
)->setStockData(
    ['use_config_manage_stock' => 0]
)->save();
